export interface ShoppingList {
  id: string;
  vendor_id: string;
  name: string;
  notes?: string;
  created_at: string;
}

export interface ShoppingListItem {
  id: string;
  shopping_list_id: string;
  item_id: string;
  item_name: string;
  quantity: number;
  unit: string;
  notes?: string;
  created_at: string;
}

export interface Seller {
  id: string;
  shop_name: string;
  delivery_options: string[];
}

export interface SellerMatchItem {
  item_name: string;
  price: number;
  stock_level: number;
}

export interface SellerMatchResult {
  seller: Seller;
  match_count: number;
  matched_items: SellerMatchItem[];
}

export type OrderStatus = 'pending' | 'confirmed' | 'fulfilled' | 'cancelled';

export interface Order {
  id: string;
  vendor_id: string;
  seller_id: string;
  shopping_list_id: string;
  total_price: number;
  status: OrderStatus;
  created_at: string;
}

export interface OrderItem {
  id: string;
  order_id: string;
  item_id: string;
  item_name: string;
  quantity: number;
  unit: string;
  unit_price: number;
  total_price: number;
} 